package com.example.possdkforandroid;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;


import POSSDK.POSSDK;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.content.IntentFilter;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.Toast;
import android.util.Xml;

public class MainActivity extends Activity {
    
	//PortType Button
	private Button usb_button; 		// USB
	private Button serial_button; 	// COM
	private Button wifi_button; 	// WIFI
	private Button blue_button; 	// Bluetooth
	
	//PortType value
	public static final int USBPORT = 1;		//USB
	public static final int SERIALPORT = 2;		//COM
	public static final int WIFIPORT = 3;		//WIFI
	public static final int BLUETOOTHPORT = 4;	//Bluetooth
	public static int port_type = 0;
	
	POSSDK self_sdk = new POSSDK();
	public static final int RECORD_LOG = 1; //0not record log,1:record log
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        //עwifi״̬㲥
        /*WifiBroad wifiReceiver = new WifiBroad();
        IntentFilter filter = new IntentFilter();
        filter.addAction(WifiManager.RSSI_CHANGED_ACTION);
        filter.addAction(WifiManager.NETWORK_STATE_CHANGED_ACTION);
        filter.addAction(WifiManager.WIFI_STATE_CHANGED_ACTION);
        this.registerReceiver(wifiReceiver, filter); */

      //Read the configuration file 
       XmlPullParser parser = null;
       int data_flag=0,log_flag=0;
       String data_file_name=null,log_file_name=null;
       FileInputStream inStream = null;
       int eventType = 0;
       
	try {
		parser = XmlPullParserFactory.newInstance().newPullParser();
	} catch (XmlPullParserException e1) {
		// TODO Auto-generated catch block
		e1.printStackTrace();
	}
       try {
		inStream = new FileInputStream("/data/bmp/log.xml");
	} catch (FileNotFoundException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
    if(inStream != null){
        try {
    		parser.setInput(inStream, "UTF-8");
    	} catch (XmlPullParserException e) {
    		e.printStackTrace();
    	} 
         try {
    		eventType = parser.getEventType();
    	} catch (XmlPullParserException e) {
    		e.printStackTrace();
    	} 
         while (eventType != XmlPullParser.END_DOCUMENT) {  
        	 if (eventType == XmlPullParser.START_TAG) {  
        	 String name = parser.getName(); 
        	 if (name.equalsIgnoreCase("data_flag")){
        		 data_flag = (new Integer(parser.getAttributeValue(null, "id")));
        	 }
        	 else if (name.equalsIgnoreCase("log_flag")){
        		 log_flag = (new Integer(parser.getAttributeValue(null, "id")));
        	 }
        	 else if (name.equalsIgnoreCase("dataname")){
        		 data_file_name = (new String(parser.getAttributeValue(null, "id")));
        	 }
        	 else if (name.equalsIgnoreCase("logname")){
        		 log_file_name = (new String(parser.getAttributeValue(null, "id")));
        	 }
        	 } 
        	 try {
    			eventType = parser.next();
    		} catch (XmlPullParserException e) {
    			e.printStackTrace();
    		} catch (IOException e) {
    			e.printStackTrace();
    		} 
        }  
    		//record data file
    		if(data_flag == 1){
    			self_sdk.recordCommunicationData(MainActivity.this,RECORD_LOG,data_file_name);
    		}
    		
    		//record log file
    		if(log_flag == 1){
    			self_sdk.LogTrace(MainActivity.this,RECORD_LOG,log_file_name);
    		}
     }else{
			Toast.makeText(MainActivity.this, "the configuration file does not exist.", Toast.LENGTH_LONG)
			.show(); 
     }
        
        //Choose USB
        usb_button=(Button)findViewById(R.id.usb_button);
        usb_button.setOnClickListener(new OnClickListener(){
			@Override
			public void onClick(View v) {
				port_type = USBPORT;
			    Intent intent = new Intent();
				intent.setClass(MainActivity.this, USBActivity.class);
				startActivity(intent);
			}});
        
        //Choose COM
        serial_button=(Button)findViewById(R.id.serial_button);
        serial_button.setOnClickListener(new OnClickListener(){
			@Override
			public void onClick(View v) {
				port_type = SERIALPORT;
			    Intent intent = new Intent();
				intent.setClass(MainActivity.this,SerialActivity.class);
				startActivity(intent);
			}});
        
        //Choose WIFI
        /*wifi_button=(Button)findViewById(R.id.wifi_button);
        wifi_button.setOnClickListener(new OnClickListener(){
			@Override
			public void onClick(View v) {
				port_type = WIFIPORT;
			    Intent intent = new Intent();
				intent.setClass(MainActivity.this,WIFIActivity.class);
				startActivity(intent);
			}});*/
        
        //Choose Bluetooth
        blue_button=(Button)findViewById(R.id.blue_button);
        blue_button.setOnClickListener(new OnClickListener(){
			@Override
			public void onClick(View v) {
				port_type = BLUETOOTHPORT;
			    Intent intent = new Intent();
				intent.setClass(MainActivity.this,BlueActivity.class);
				startActivity(intent);
			}});
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
}
